# Spektrum bind support

Spektrum bind with hardware bind plug support.

The Spektrum bind code is enabled for the boards listed in the section [Supported firmware and hardware ports](#Supported firmware and hardware ports)

## Developement - configuring the bind code

The following parameters can be used to enable and configure this in the related target.h file:

    SPEKTRUM_BIND          Enables the Spektrum bind code
    BIND_PORT  GPIOA       Defines the port for the bind pin
    BIND_PIN   Pin_3       Defines the bind pin (the satellite receiver is connected to)

This is to activate the hardware bind plug feature

    HARDWARE_BIND_PLUG     Enables the hardware bind plug feature
    BINDPLUG_PORT  GPIOB   Defines the port for the hardware bind plug
    BINDPLUG_PIN   Pin_5   Defines the hardware bind plug pin

## Hardware

The hardware bind plug will be enabled via defining HARDWARE_BIND_PLUG during building of the firmware. BINDPLUG_PORT and BINDPLUG_PIN also need to be defined (please see above). The hardware bind plug is expected between the defined bind pin and ground.

## Supported firmware and hardware ports

Note that the bind pin *may* not be the UART pin normally associated with the serial RX.

| Board | Bind Pin | UART Pin |
| ----- | -------- | -------- |
| AIRBOTF4 | PB11 | UART3 RX  |
| AIRHEROF3 | PB11 | UART3 RX  |
| ALIENFLIGHTF3 | PA3 | UART2 RX  |
| BETAFLIGHTF4 | PB11 | UART3 RX  |
| BLUEJAYF4 | PB11 | UART3 RX  |
| FALCORE | PA3 | UART2 RX  |
| FURYF3 | PB11 | UART3 RX  |
| LUX_RACE | PC5 | UART1 RX  |
| MATEKF405 | PA3 | UART2 RX  |
| MATEKF405SE | PA3 | UART2 RX  |
| MATEKF411 | PA10 | UART1 RX  |
| MATEKF411SE | PA3 | UART2 RX  |
| MATEKF722 | PA3 | UART2 RX  |
| MOTOLAB | PB4 | UART2 RX  |
| OMNIBUS | PB11 | UART3 RX  |
| OMNIBUSF4 | PB11 | UART3 RX  |
| PIKOBLX | PB11 | UART3 RX  |
| RCEXPLORERF3 | PA3 | UART2 RX  |
| REVO | PB11 | UART3 RX  |
| RMDO | PB11 | UART3 RX  |
| SPARKY | PA3 | UART2 RX  |
| SPEEDYBEEF4 | PC11 | UART3 RX  |
| SPRACINGF3 | PB11 | UART3 RX  |
| SPRACINGF3EVO | PB11 | UART3 RX  |
| SPRACINGF3MINI | PB11 | UART3 RX  |

*Table automagically generated by `mwptools/samples/spkbind.rb` 2019-08-16. E&OE, update at your own convenience.*

## Function

The spektrum_sat_bind CLI parameter is defining the number of bind impulses (1-10) send to the satellite receiver. Setting spektrum_sat_bind to zero will disable the bind mode in any case. The bind mode will only be activated after an power on or hard reset. Please refer to the table below for the different possible values.

If the hardware bind plug is configured the bind mode will only be activated if the plug is set during the firmware start-up. The value of the spektrum_sat_bind parameter will be permanently preserved. The bind plug should be always removed for normal flying.

If no hardware bind plug is used the spektrum_sat_bind parameter will trigger the bind process during the next hardware reset and will be automatically reset to "0" after this.

Please refer to the satellite receiver documentation for more details of the specific receiver in bind mode. Usually the bind mode will be indicated with some flashing LEDs.

## Table with spektrum_sat_bind parameter value

| Value | Receiver mode     |
| ----- | ------------------|
| 3     | DSM2 1024bit/22ms |
| 5     | DSM2 2048bit/11ms |
| 7     | DSMX 1024bit/22ms |
| 9     | DSMX 2048bit/11ms |

More detailed information regarding the satellite binding process can be found here:
http://wiki.openpilot.org/display/Doc/Spektrum+Satellite

#### Tested satellite transmitter combinations

| Satellite            | Remote         | Remark                                                   |
| -------------------- | -------------- | -------------------------------------------------------- |
| Orange R100          | Spektrum DX6i  | Bind value 3                                             |
| Lemon RX DSM2/DSMX   | Spektrum DX8   | Bind value 5                                             |
| Lemon RX DSMX        | Walkera Devo10 | Bind value 9, Deviation firmware 4.01 up to 12 channels  |
| Lemon RX DSM2        | Walkera Devo7  | Bind value 9, Deviation firmware                         |
